var timer = null;

/**
 * This class implements the countdown timer and the alarm function.
 */
function Timer() {
	this._targetTime = null;
	this._isTargetReached = false;
	this.isPaused = false;
	this.hours = -1;
	this.minutes = -1;
	this.seconds = -1;
	this.remainingHours = -1;
	this.remainingMinutes = -1;
	this.remainingSeconds = -1;
	this.timerInterval = null;
	this.stopClicked = false;
	this._msCounter = 0;
}

/**
 * Run the countdown.
 */
Timer.prototype.run = function() {
    var h, m, s;
    
    if (!timer.isPaused) {
		timer.hours = $('#hours').text()
		timer.minutes = $('#minutes').text()
		timer.seconds = $('#seconds').text()
		h = parseInt(timer.hours, 10);
		m = parseInt(timer.minutes, 10);
		s = parseInt(timer.seconds, 10);  
    }
    else {
        timer.isPaused = false;
        h = timer.remainingHours;
        m = timer.remainingMinutes;
        s = timer.remainingSeconds;
    }
	m += h * 60;
	s += m * 60;
	timer._targetTime = Date.parse(new Date()) + s * 1000;
	timer._isTargetReached = false; 

	// Check if target time has already been passed.
	if (timer._targetTime > Date.parse(new Date())) {
		timer.timerInterval = setInterval('timer.runTimer()', 1000);
	}
	else {
		front.resetDisplay();
	}
};

/**
 * Pause the countdown.
 */
Timer.prototype.pause = function() {
	clearInterval(timer.timerInterval);
	timer.timerInterval = null;
	timer.isPaused = true
};

/**
 * Rewind the countdown – set it back to it initial value.
 */
Timer.prototype.rewind = function() {
	clearInterval(timer.timerInterval);
	timer.timerInterval = null;
	timer._isTargetReached = false;
	timer.isPaused = false;
	front.resetDisplayTo(timer.hours, timer.minutes, timer.seconds);
};

/**
 * Stop the alarm.
 */
Timer.prototype.stopAlarm = function() {
    timer.stopClicked = true;
};


/**
 * The run timer action first calculates the remaining time, then updates
 * the displayed time and finally checks wheter to alarm the user or not.
 */
Timer.prototype.runTimer = function() {
    timer.calculateRemainingTime();
    front.updateTimerDisplay();
    timer.checkForAlarm();
};

/**
 * Calculate the remaining hours, minutes and seconds and write them to their
 * corresponding global vars.
 */
Timer.prototype.calculateRemainingTime = function() {
	currentTime = Date.parse(new Date());
	timer.remainingSeconds = (timer._targetTime - currentTime) / 1000;
	timer.remainingMinutes = parseInt(timer.remainingSeconds / 60);
	timer.remainingHours = parseInt(timer.remainingMinutes / 60);
	timer.remainingSeconds %= 60;
	timer.remainingMinutes %= 60;
};

/**
 * Check if the target time is reached and alarm the user.
 */
Timer.prototype.checkForAlarm = function() {
	if (timer.remainingSeconds <= 0 && timer.remainingMinutes <= 0 
			&& timer.remainingHours <= 0 && !timer._isTargetReached) {
		clearInterval(timer.timerInterval);
		timer.timerInterval = null;
		timer._isTargetReached = true;
		timer.isPaused = false;
		front.resetDisplayTo(timer.hours, timer.minutes, timer.seconds);
		if (alarm.keepAlarming)
			front.showStopAlarmButton();
			timer.stopClicked = false;
        timer.alarm();
	}
};

/**
 * Alarm the user according to his preferences.
 *
 * If type is not set, all alarms set in alarm will be used. This is the case
 * for normal alarms. Else only the alarm specified via type will be used. This
 * is the case if the user switches is prefrences and a “preview alarm” is
 * raised.
 *
 * @param type: Specifies a special (and only) alarm to be raised. May be
 *              "sound", "voice" or "growl". If not set, all alarm types will
 *              be used.
 */
Timer.prototype.alarm = function(type) {
	var title = getLocalizedString('Tea Timer');
	var message = $('#timerTarget').text();
	if ($('#readyIn').text() == getLocalizedString('ready in'))
	 	message += ' ' + getLocalizedString('is ready.');

	if ((!type || type == 'sound') && alarm.sound != 'none') {
		if (window.widget) {
			widget.system('/usr/bin/afplay /System/Library/Sounds/' + alarm.sound + '.aiff', null);
		}
	}
	if (window.widget && (!type || type == 'growl') && alarm.growl) {
		widget.system('/usr/bin/env python growl.py "' + title + '" "' 
				+ message + '"', null);
	}
	if (window.widget && (!type || type == 'voice') && alarm.voice != 'none') {
		widget.system('/usr/bin/osascript -e \'say "' + message
						+ '" using "' + alarm.voice + '"\'', null);
	}
	
	if (window.widget && alarm.keepAlarming && !type && !timer.stopClicked) {
		timer.repeatAlarm();
	}
};

/**
 *
 */
Timer.prototype.repeatAlarm = function() {
	if (timer.stopClicked) {
		timer._msCounter == 0;
		return;
	}
	timer._msCounter = (timer._msCounter + 10) % 5000;
	if (timer._msCounter == 0)
		timer.alarm();
	else
		setTimeout('timer.repeatAlarm()', 10);
};

